
### 1. Traditional Patching Approach

#### Definition

- Manual installation of patches or use of automated patch management systems.
- Primarily focused on devices within a secure perimeter (e.g., main office, branches) protected by a firewall.

#### Limitations

- Ineffective for remote or hybrid workforces.
- Requires devices to be within the internal network for updates.

---

### 2. Cloud-Based Patch Management

#### Definition & Mechanism

- A centralized environment for patch management.
- Accessible "always and everywhere" as long as the client has Internet access.

#### Key Benefits

- **Simplifies Process:** Keeps company devices free from known vulnerabilities.
- **Centralized Environment:** Single point of management.
- **Ubiquitous Availability:** Works for remote and distributed teams.
- **Network Device Discovery:** Helps identify all devices accessing company resources before patching.

#### Core Principle

- Ensures all internetworked devices are constantly updated.

---

### 3. Limitations and Challenges of Patching (Even Cloud-Based)

#### Scope of Protection

- **Known Vulnerabilities Only:** Patches only address vulnerabilities that have already been identified.
- **Time Lag:** New patches require testing before implementation, creating a window of vulnerability.

#### Specific Scenarios Not Covered

- **Custom/End-of-Support Applications:** Cloud patch management may not cover applications that are proprietary, highly customized, or no longer officially supported.
- **Mission-Critical Systems:**
    - Systems requiring non-stop availability (e.g., hospitals) cannot easily apply patches that necessitate a reboot.
    - Standard patching methods may disrupt critical operations.